/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.ui.campfire;

import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.ui.campfire.AbstractCampfireOption;
import com.megacrit.cardcrawl.vfx.campfire.CampfireSleepEffect;
import com.megacrit.cardcrawl.vfx.campfire.CampfireSleepScreenCoverEffect;

public class RestOption
extends AbstractCampfireOption {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("Rest Option");
    public static final String[] TEXT = RestOption.uiStrings.TEXT;

    public RestOption() {
        this.label = TEXT[0];
        int healAmt = DailyMods.mods.get("Night Terrors") != false ? (int)((float)AbstractDungeon.player.maxHealth * 0.2f) : (int)((float)AbstractDungeon.player.maxHealth * 0.3f);
        if (DailyMods.mods.get("Night Terrors").booleanValue()) {
            this.description = TEXT[1] + healAmt + ").";
            if (AbstractDungeon.player.hasRelic("Regal Pillow")) {
                this.description = this.description + "\n+15" + TEXT[2] + AbstractDungeon.player.getRelic((String)"Regal Pillow").name + ".";
            }
        } else {
            this.description = TEXT[3] + healAmt + ").";
            if (AbstractDungeon.player.hasRelic("Regal Pillow")) {
                this.description = this.description + "\n+15" + TEXT[2] + AbstractDungeon.player.getRelic((String)"Regal Pillow").name + ".";
            }
        }
        this.img = ImageMaster.CAMPFIRE_REST_BUTTON;
    }

    @Override
    public void useOption() {
        CardCrawlGame.sound.play("SLEEP_BLANKET");
        AbstractDungeon.effectList.add(new CampfireSleepEffect());
        for (int i = 0; i < 30; ++i) {
            AbstractDungeon.topLevelEffects.add(new CampfireSleepScreenCoverEffect());
        }
        ++CardCrawlGame.metricData.campfire_rested;
    }
}

